DROP TABLE IF EXISTS `invoices`;
CREATE TABLE `invoices` (
  `invoice_id` int(11) NOT NULL auto_increment,
  `invoice_number` varchar(255) NOT NULL default '',
  `invoice_date` datetime default NULL,
  `invoice_file` VARCHAR(255) NOT NULL DEFAULT '',
  `customer_id` int(11) NOT NULL default '0',
  `customer_status_id` int(11) default NULL,
  `customer_status_name` varchar(32) NOT NULL default '',
  `total_sum` decimal(14,6) default NULL,
  `currency` char(3) default NULL,
  `customers_firstname` varchar(64) NOT NULL default '',
  `customers_lastname` varchar(64) NOT NULL default '',
  `delivery_firstname` varchar(64) NOT NULL default '',
  `delivery_lastname` varchar(64) NOT NULL default '',
  `delivery_company` varchar(255) default NULL,
  `delivery_street_address` varchar(64) NOT NULL default '',
  `delivery_house_number` varchar(64) NOT NULL default '',
  `delivery_additional_info` varchar(255) NOT NULL default '',
  `delivery_suburb` varchar(32) default NULL,
  `delivery_city` varchar(32) NOT NULL default '',
  `delivery_postcode` varchar(10) NOT NULL default '',
  `delivery_state` varchar(32) default NULL,
  `delivery_country` varchar(64) NOT NULL default '',
  `delivery_country_iso_code_2` char(2) NOT NULL default '',
  `delivery_address_format_id` int(5) NOT NULL default '0',
  `billing_firstname` varchar(64) NOT NULL default '',
  `billing_lastname` varchar(64) NOT NULL default '',
  `billing_company` varchar(255) default NULL,
  `billing_street_address` varchar(64) NOT NULL default '',
  `billing_house_number` varchar(64) NOT NULL default '',
  `billing_additional_info` varchar(255) NOT NULL default '',
  `billing_suburb` varchar(32) default NULL,
  `billing_city` varchar(32) NOT NULL default '',
  `billing_postcode` varchar(10) NOT NULL default '',
  `billing_state` varchar(32) default NULL,
  `billing_country` varchar(64) NOT NULL default '',
  `billing_country_iso_code_2` char(2) NOT NULL default '',
  `billing_address_format_id` int(5) NOT NULL default '0',
  `order_id` int(11) NOT NULL default '0',
  `order_date_purchased` datetime default NULL,
  `payment_method` varchar(32) NOT NULL default '',
  `payment_class` varchar(32) NOT NULL default '',
  PRIMARY KEY  (`invoice_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;